<?php declare(strict_types=1);
defined('MW_PATH') or exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 1.0
 */

/** @var Controller $controller */
$controller = controller();

/** @var string $pageHeading */
$pageHeading = (string)$controller->getData('pageHeading');

/** @var ArticleCategory $category */
$category = $controller->getData('category');

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->getData()}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->add('renderContent', false)}
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
try {
    hooks()->doAction('before_view_file_content', $viewCollection = new CAttributeCollection([
        'controller'    => $controller,
        'renderContent' => true,
    ]));
} catch (Exception $e) {
}

// and render if allowed
if (!empty($viewCollection) && $viewCollection->itemAt('renderContent')) { ?>
    <div class="box box-primary borderless">
        <div class="box-header">
            <div class="pull-left">
                <?php BoxHeaderContent::make(BoxHeaderContent::LEFT)
                    ->add('<h3 class="box-title">' . IconHelper::make('glyphicon-book') . html_encode((string)$pageHeading) . '</h3>')
                    ->render();
                ?>
            </div>
            <div class="pull-right">
                <?php try {
                    BoxHeaderContent::make(BoxHeaderContent::RIGHT)
                        ->add($controller->widget('common.components.web.widgets.GridViewToggleColumns', ['model' => $category, 'columns' => ['name', 'status', 'date_added', 'last_updated']], true))
                        ->add(HtmlHelper::accessLink(IconHelper::make('create') . t('app', 'Create new'), ['article_categories/create'], ['class' => 'btn btn-primary btn-flat', 'title' => t('app', 'Create new')]))
                        ->add(HtmlHelper::accessLink(IconHelper::make('refresh') . t('app', 'Refresh'), ['article_categories/index'], ['class' => 'btn btn-primary btn-flat', 'title' => t('app', 'Refresh')]))
                        ->render();
                } catch (Exception $e) {
                }
                ?>
            </div>
            <div class="clearfix"><!-- --></div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
            <?php
            /**
             * This hook gives a chance to prepend content or to replace the default grid view content with a custom content.
             * Please note that from inside the action callback you can access all the controller view
             * variables via {@CAttributeCollection $collection->controller->getData()}
             * In case the content is replaced, make sure to set {@CAttributeCollection $collection->itemAt('renderGrid')} to false
             * in order to stop rendering the default content.
             * @since 1.3.3.1
             */
            try {
                hooks()->doAction('before_grid_view', $collection = new CAttributeCollection([
                    'controller' => $controller,
                    'renderGrid' => true,
                ]));
            } catch (Exception $e) {
            }

            // and render if allowed
            if (!empty($collection) && $collection->itemAt('renderGrid')) {
                try {
                    $controller->widget('zii.widgets.grid.CGridView', hooks()->applyFilters('grid_view_properties', [
                        'ajaxUrl'        => createUrl($controller->getRoute()),
                        'id'             => $category->getModelName() . '-grid',
                        'dataProvider'   => $category->search(),
                        'filter'         => $category,
                        'filterPosition' => 'body',
                        'filterCssClass' => 'grid-filter-cell',
                        'itemsCssClass'  => 'table table-hover',
                        'selectableRows' => 0,
                        'enableSorting'  => false,
                        'cssFile'        => false,
                        'pagerCssClass'  => 'pagination pull-right',
                        'pager'          => [
                            'class'       => 'CLinkPager',
                            'cssFile'     => false,
                            'header'      => false,
                            'htmlOptions' => ['class' => 'pagination'],
                        ],
                        'columns'        => hooks()->applyFilters('grid_view_columns', [
                            [
                                'name'  => 'name',
                                'value' => '$data->getParentNameTrail()',
                            ],
                            [
                                'name'   => 'status',
                                'value'  => '$data->statusText',
                                'filter' => $category->getStatusesArray(),
                            ],
                            [
                                'name'   => 'date_added',
                                'value'  => '$data->dateAdded',
                                'filter' => false,
                            ],
                            [
                                'name'   => 'last_updated',
                                'value'  => '$data->lastUpdated',
                                'filter' => false,
                            ],
                            [
                                'class'             => 'DropDownButtonColumn',
                                'header'            => t('app', 'Options'),
                                'footer'            => $category->paginationOptions->getGridFooterPagination(),
                                'buttons'           => [
                                    'view'   => [
                                        'label'    => IconHelper::make('view'),
                                        'url'      => '$data->permalink',
                                        'imageUrl' => null,
                                        'options'  => [
                                            'title'  => t('app', 'View'),
                                            'class'  => 'btn btn-primary btn-flat',
                                            'target' => '_blank',
                                        ],
                                    ],
                                    'update' => [
                                        'label'    => IconHelper::make('update'),
                                        'url'      => 'createUrl("article_categories/update", array("id" => $data->category_id))',
                                        'imageUrl' => null,
                                        'options'  => [
                                            'title' => t('app', 'Update'),
                                            'class' => 'btn btn-primary btn-flat',
                                        ],
                                        'visible'  => 'AccessHelper::hasRouteAccess("article_categories/update")',
                                    ],
                                    'delete' => [
                                        'label'    => IconHelper::make('delete'),
                                        'url'      => 'createUrl("article_categories/delete", array("id" => $data->category_id))',
                                        'imageUrl' => null,
                                        'options'  => [
                                            'title' => t('app', 'Delete'),
                                            'class' => 'btn btn-danger btn-flat delete',
                                        ],
                                        'visible'  => 'AccessHelper::hasRouteAccess("article_categories/delete")',
                                    ],
                                ],
                                'headerHtmlOptions' => ['style' => 'text-align: right'],
                                'footerHtmlOptions' => ['align' => 'right'],
                                'htmlOptions'       => ['align' => 'right', 'class' => 'options'],
                                'template'          => '{view} {update} {delete}',
                            ],
                        ], $controller),
                    ], $controller));
                } catch (Exception $e) {
                }
            }
            /**
             * This hook gives a chance to append content after the grid view content.
             * Please note that from inside the action callback you can access all the controller view
             * variables via {@CAttributeCollection $collection->controller->getData()}
             * @since 1.3.3.1
             */
            try {
                hooks()->doAction('after_grid_view', new CAttributeCollection([
                    'controller'   => $controller,
                    'renderedGrid' => !empty($collection) ? $collection->itemAt('renderGrid') : false,
                ]));
            } catch (Exception $e) {
            }
            ?>
            <div class="clearfix"><!-- --></div>
            </div>
        </div>
    </div>
<?php
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->getData()}
 * @since 1.3.3.1
 */
try {
    hooks()->doAction('after_view_file_content', new CAttributeCollection([
        'controller'      => $controller,
        'renderedContent' => !empty($viewCollection) ? $viewCollection->itemAt('renderContent') : false,
    ]));
} catch (Exception $e) {
}
